const puppeteer = require('puppeteer');
const path = require('path');

async function generateScreenshots() {
    console.log('Starting screenshot generation...');
    const browser = await puppeteer.launch({ headless: true });
    const page = await browser.newPage();
    console.log('Browser launched and page created');

    // Set viewport for screenshots
    await page.setViewport({ width: 1280, height: 800 });

    // Generate screenshot 1 (Login)
    console.log('Generating screenshot 1...');
    await page.goto(`file://${path.join(__dirname, 'screenshot1.html')}`);
    await new Promise(resolve => setTimeout(resolve, 1000));
    await page.screenshot({ 
        path: path.join(__dirname, 'screenshot1.png'),
        fullPage: false
    });
    console.log('Screenshot 1 saved');

    // Generate screenshot 2 (Dashboard)
    await page.goto(`file://${path.join(__dirname, 'screenshot2.html')}`);
    await new Promise(resolve => setTimeout(resolve, 1000));
    await page.screenshot({ 
        path: path.join(__dirname, 'screenshot2.png'),
        fullPage: false
    });

    // Generate screenshot 3 (Time Tracking)
    await page.goto(`file://${path.join(__dirname, 'screenshot3.html')}`);
    await new Promise(resolve => setTimeout(resolve, 1000));
    await page.screenshot({ 
        path: path.join(__dirname, 'screenshot3.png'),
        fullPage: false
    });

    // Generate small promo tile (440x280)
    await page.setViewport({ width: 440, height: 280 });
    await page.goto(`file://${path.join(__dirname, 'small_promo.html')}`);
    await new Promise(resolve => setTimeout(resolve, 1000));
    await page.screenshot({ 
        path: path.join(__dirname, 'small_promo_tile.png'),
        fullPage: false
    });

    // Generate marquee promo tile (1400x560)
    await page.setViewport({ width: 1400, height: 560 });
    await page.goto(`file://${path.join(__dirname, 'marquee_promo.html')}`);
    await new Promise(resolve => setTimeout(resolve, 1000));
    await page.screenshot({ 
        path: path.join(__dirname, 'marquee_promo_tile.png'),
        fullPage: false
    });

    await browser.close();
    console.log('Screenshots generated successfully!');
}

generateScreenshots().catch(console.error);
