//variables to hold the indexedDB database.
var dbMoviesDatabase;
var dbName = "MoviesDatabase";
var dbVersion = 1;
// open the indexedDB database
var request = indexedDB.open(dbName, dbVersion);
//check if an upgrade is needed, this due to a version change
request.onupgradeneeded = function(e) {
    var thisDB = e.target.result;
    var store = null;
    //create the necessary tables for the application
    // create an indexedDB for IndexedDB-Movie
    if (!thisDB.objectStoreNames.contains("Movie")) {
        // create objectStore for PrimaryKey as keyPath="MovieName"
        store = thisDB.createObjectStore("Movie", {keyPath: "MovieName" });
        // thisDB.createObjectStore("Movie", { autoIncrement: true });
        // create index to 'name' for conditional search
        // store.createIndex('name', 'name', {unique: false });
    }
};
//the database was opened successfully
request.onsuccess = function(e) {
    dbMoviesDatabase = e.target.result;
}