// WorkStatus Extension Script
// This file contains utility functions for the WorkStatus extension

async function getUserDetail(){
    try {
        // Get user details from localStorage
        const userDetail = localStorage.getItem("userDetail");
        if (userDetail) {
            return JSON.parse(userDetail);
        }
        return null;
    } catch (error) {
        console.error("Error getting user details:", error);
        return null;
    }
}

// Initialize the extension when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Extension initialization code can go here
    console.log("WorkStatus extension initialized");
});
