function json(url) {
  return fetch(url).then((res) => res.json());
}
chrome.storage.local.get(["time_zone"]).then((time_zoneresult) => {
  json(
    endpointUrl + `getCurrentTime?timezone=${time_zoneresult.time_zone}`
  ).then(async (timerdata) => {
    if (timerdata.response.code == 200) {
      if (
        moment(new Date()).format("YYYY-MM-DD HH:mm") ==
        moment(timerdata.response.time).format("YYYY-MM-DD HH:mm")
      ) {
        chrome.storage.local.set({ time_changed: 0 });
      }
    }
  });
});

chrome.storage.local.get(["start_time"]).then((result) => {
  if (result.start_time) {
    var start = result.start_time;
  } else {
    var start = result.start_time;
  }
});

// userdel
// tzchange
// errortext

const isTZCHANGE = async () => {
  return new Promise((resolve, reject) => {
    chrome.storage.local.get("tzchange", (result) => {
      if (chrome.runtime.lastError) {
        reject(chrome.runtime.lastError); // Reject if there's an error
      } else {
        resolve(result.tzchange || 0); // Resolve with the data or null
      }
    });
  });
};

const isUserDel = async () => {
  return new Promise((resolve, reject) => {
    chrome.storage.local.get("userdel", (result) => {
      if (chrome.runtime.lastError) {
        reject(chrome.runtime.lastError); // Reject if there's an error
      } else {
        resolve(result.userdel || 0); // Resolve with the data or null
      }
    });
  });
};

setInterval(async () => {
  let tz = await isTZCHANGE();
  let userdel = await isUserDel();
  if (tz == 1) {
    document.getElementById("errortext").innerHTML =
      "User Has Changed The Timezone";
  } else if (userdel == 1) {
    document.getElementById("errortext").innerHTML =
      "User Has Been Deactivated Or Deleted";
  }
}, 1000);
