#!/bin/bash

# WorkStatus Chrome Extension - Package Recreation Script
echo "🔄 Recreating Chrome Web Store package..."

# Remove old package
rm -rf chrome_web_store_package

# Create new package directory
mkdir chrome_web_store_package

# Copy essential files
echo "📁 Copying extension files..."
cp -r css fonts html images js *.html *.js *.json offscreen.* chrome_web_store_package/

# Copy store assets
echo "🖼️ Copying store assets..."
cp store_assets/*.png chrome_web_store_package/

# Create zip package
echo "📦 Creating zip package..."
cd chrome_web_store_package
zip -r ../workstatus-chrome-extension-v1.0.2-final.zip . -x "*.DS_Store" "node_modules/*" "*.log" > /dev/null
cd ..

echo "✅ Package recreated successfully!"
echo "📁 Package location: chrome_web_store_package/"
echo "📦 Zip file: workstatus-chrome-extension-v1.0.2-final.zip"

rm -rf chrome_web_store_package

echo "🔄 Removing old package..."